<?php
function page($page,$total,$phpfile,$pagesize=1,$pagelen=3){
    $pagecode = "";
    $page = intval($page);
    $total = intval($total);
    if(!$total) 
        return array();
    $pages = ceil($total/$pagesize);
    
    if($page<1) 
        $page = 1;
    if($page>$pages) 
        $page = $pages;
    
    $offset = $pagesize*($page-1);

    $init = 1;
    $max = $pages;
    $pagelen = ($pagelen%2)?$pagelen:$pagelen+1;
    $pageoffset = ($pagelen-1)/2;
    
    $pagecode="<span ><div class='pg'>";
    $pagecode.="<a> $page/$pages </a>";

    if($page!=1){
        $pagecode.="<a href=\"{$phpfile}&page=1\"><<</a>"; 
        $pagecode.="<a class='prev' href=\"{$phpfile}&page=".($page-1)."\"> < </a>"; 
    }

    if($pages>$pagelen){

        if($page<=$pageoffset){
            $init=1;
            $max = $pagelen;
        }else{
            
            if($page+$pageoffset>=$pages+1){
                $init = $pages-$pagelen+1;
            }else{
                
                $init = $page-$pageoffset;
                $max = $page+$pageoffset;
            }
        }
    }
    
    for($i=$init;$i<=$max;$i++){
        if($i==$page){
            $pagecode.="<strong>{$i}</strong>";
        } else {
            $pagecode.="<a href=\"{$phpfile}&page={$i}\"> $i </a>";
        }
    }
    if($page!=$pages){
        $pagecode.="<a class='nxt' href=\"{$phpfile}&page=".($page+1)."\"> > </a>"; 
        $pagecode.="<a href=\"{$phpfile}&page={$pages}\"> >> </a>"; 
    }
    $pagecode.='</div></span>';
    return array('pagecode'=>$pagecode,'sqllimit'=>' limit '.$offset.','.$pagesize);
}

function showtipss($tips, $id = 'tips', $display = TRUE, $title = '') {
	$tips = cplang($tips);
	$tips = preg_replace('#</li>\s*<li>#i', '</li><li>', $tips);
	$tmp = explode('</li><li>', substr($tips, 4, -5));
	if(!count($tmp) > 4) {
		$tips = '<li>'.$tmp[0].'</li><li>'.$tmp[1].'</li><li id="'.$id.'_more" style="border: none; background: none; margin-bottom: 6px;"><a href="###" onclick="var tiplis = $(\''.$id.'lis\').getElementsByTagName(\'li\');for(var i = 0; i < tiplis.length; i++){tiplis[i].style.display=\'\'}$(\''.$id.'_more\').style.display=\'none\';">'.cplang('tips_all').'...</a></li>';
		foreach($tmp AS $k => $v) {
			if($k > 1) {
				$tips .= '<li style="display: none">'.$v.'</li>';
			}
		}
	}
	unset($tmp);
	$title = $title ? $title : 'tips';
	showtableheaders($title, '', 'id="'.$id.'"'.(!$display ? ' style="display: none;"' : ''), 0);
	showtablerow('', 'class="tipsblock" s="1"', '<ul id="'.$id.'lis">'.$tips.'</ul>');
	showtablefooter();
}

function showtableheaders($title = '', $classname = '', $extra = '', $titlespan = 15) {
	global $_G;
	$classname = str_replace(array('nobottom', 'notop'), array('nobdb', 'nobdt'), $classname);
	if(isset($_G['showsetting_multi'])) {
		if($_G['showsetting_multi'] == 0) {
			$extra .= ' style="width:'.($_G['showsetting_multicount'] * 270 + 20).'px"';
		} else {
			return;
		}
	}
	echo "\n".'<table class="tb tb2 '.$classname.'"'.($extra ? " $extra" : '').' style="clear: both;margin-top: 35px;width: 100%">';
	if($title) {
		$span = $titlespan ? 'colspan="'.$titlespan.'"' : '';
		echo "\n".'<tr><th '.$span.' class="partition">'.cplang($title).'</th></tr>';
		showmultititle(1);
	}
}

function showsubmenus($title, $menus = array(), $right = '', $replace = array()) {
	if(empty($menus)) {
		$s = '<div class="itemtitle">'.$right.'<h3>'.cplang($title, $replace).'</h3></div>';
	} elseif(is_array($menus)) {
		$s = '<div class="itemtitle">'.$right.'<h3>'.cplang($title, $replace).'</h3><ul class="tab1">';
		foreach($menus as $k => $menu) {
			if(is_array($menu[0])) {
				$s .= '<li id="addjs'.$k.'" class="'.($menu[1] ? 'current' : 'hasdropmenu').'" onmouseover="dropmenu(this);"><a href="#"><span>'.cplang($menu[0]['menu']).'<em>&nbsp;&nbsp;</em></span></a><div id="addjs'.$k.'child" class="dropmenu" style="display:none;">';
				if(is_array($menu[0]['submenu'])) {
					foreach($menu[0]['submenu'] as $submenu) {
						$s .= $submenu[1] ? '<a href="'.ADMINSCRIPT.'?action='.$submenu[1].'" class="'.($submenu[2] ? 'current' : '').'" onclick="'.$submenu[3].'">'.cplang($submenu[0]).'</a>' : '<a><b>'.cplang($submenu[0]).'</b></a>';
					}
				}
				$s .= '</div></li>';
			} else {
				$s .= '<li'.($menu[2] ? ' class="current"' : '').'><a href="'.(!$menu[4] ? ADMINSCRIPT.'?action='.$menu[1] : $menu[1]).'"'.(!empty($menu[3]) ? ' target="_blank"' : '').'><span>'.cplang($menu[0]).'</span></a></li>';
			}
		}
		$s .= '</ul></div>';
	}
	echo !empty($menus) ? '<div class="floattop" style="top:30px;">'.$s.'</div>' : $s;
}




?>