<?php


function touclick_request($url, $data, $port) {
	$data = http_build_query($data);
	$url = parse_url($url);
	if ($url['scheme'] != 'http') {
		die('Error: Only HTTP request are supported !');
	}
	$host = $url['host'];
	$path = $url['path'];
	$fp = tcfsocketopen($host, $port, $errno, $errstr, 15);
	if ($fp){
		fputs($fp, "POST $path HTTP/1.1\r\n");
		fputs($fp, "Host: $host\r\n");
		fputs($fp, "Content-type: application/x-www-form-urlencoded\r\n");
		fputs($fp, "Content-length: ". strlen($data) ."\r\n");
		fputs($fp, "Connection: close\r\n\r\n");
		fputs($fp, $data);
		$result = '';
		while(!feof($fp)) {
			$result .= fgets($fp, 1028);
		}
	}
	else {
		return array(
				'status' => 'err',
				'error' => "$errstr ($errno)"
		);
	}
	fclose($fp);
	$result = explode("\r\n\r\n", $result, 2);
	$header = isset($result[0]) ? $result[0] : '';
	$content = isset($result[1]) ? $result[1] : '';
    
    preg_match('/(\<\<.*?\>\>)/is',$content, $match);
    
    $temp = substr($match[0], 2, -2);
	return array(
			'status' => 'ok',
			'content' => $temp
	);
}


function touclick_requestPST($url, $path, $data, $port) {
	$data = http_build_query($data);
	$url = parse_url($url);
	if ($url['scheme'] != 'http') {
		die('Error: Only HTTP request are supported !');
	}
	$host = $url['host'];
	$fp = tcfsocketopen($host, $port, $errno, $errstr, 15);
	if ($fp){
		fputs($fp, "GET $path HTTP/1.1\r\n");
		fputs($fp, "Host: $host\r\n");
		fputs($fp, "Content-type: application/x-www-form-urlencoded\r\n");
		fputs($fp, "Content-length: ". strlen($data) ."\r\n");
		fputs($fp, "Connection: close\r\n\r\n");
		fputs($fp, $data);
		$result = '';
		while(!feof($fp)) {
			$result .= fgets($fp, 1028);
		}
	}
	else {
		return array(
				'status' => 'err',
				'error' => "$errstr ($errno)"
		);
	}
	fclose($fp);
	$result = explode("\r\n\r\n", $result, 2);
	$header = isset($result[0]) ? $result[0] : '';
	$content = isset($result[1]) ? $result[1] : '';
	return array(
			'status' => 'ok',
			'content' => $content,
	);
}

function touclick_requestCTL($url, $path, $data, $port) {
	$data = http_build_query($data);
	$url = parse_url($url);
	if ($url['scheme'] != 'http') {
		die('Error: Only HTTP request are supported !');
	}
	$host = $url['host'];
	$fp = tcfsocketopen($host, $port, $errno, $errstr, 15);
	if ($fp){
		fputs($fp, "GET $path HTTP/1.1\r\n");
		fputs($fp, "Host: $host\r\n");
		fputs($fp, "Content-type: application/x-www-form-urlencoded\r\n");
		fputs($fp, "Content-length: ". strlen($data) ."\r\n");
		fputs($fp, "Connection: close\r\n\r\n");
		fputs($fp, $data);
		$result = '';
		while(!feof($fp)) {
			$result .= fgets($fp, 1028);
		}
	}
	else {
		return array(
				'status' => 'err',
				'error' => "$errstr ($errno)"
		);
	}
	fclose($fp);
	$result = explode("\r\n\r\n", $result, 2);
	$header = isset($result[0]) ? $result[0] : '';
	$content = isset($result[1]) ? $result[1] : '';
	
	preg_match('/(\<\<.*?\>\>)/is',$content, $match);
	
	$temp = substr($match[0], 2, -2);
	return array(
			'status' => 'ok',
			'content' => $temp,
	);
}

function tcfsocketopen($hostname, $port = 80, &$errno, &$errstr, $timeout = 15) {
	$fp = '';
	if(function_exists('fsockopen')) {
		$fp = @fsockopen($hostname, $port, $errno, $errstr, $timeout);
	} elseif(function_exists('pfsockopen')) {
		$fp = @pfsockopen($hostname, $port, $errno, $errstr, $timeout);
	} elseif(function_exists('stream_socket_client')) {
		$fp = @stream_socket_client($hostname.':'.$port, $errno, $errstr, $timeout);
	}
	return $fp;
}

?>