<?PHP
include_once 'touclick_json.php';

class touclick_content{
	private $apiurl = "http://content1.touclick.com/touclick.secu";
	private $apidourl = "http://content1.touclick.com/touclick.kvalue";
	private $version = '2';
	private $config = array();
	public function __construct(){
		$this->config = array(
			'pubkey'=>'',
			'ip'=>'0.0.0.0',
			'username'=>'',
			'uid'=>'',
			'charset'=>'gbk',
			'subject'=>'',
			'message'=>'',
			'mod'=>'02',
			'groupid'=>'',
		);
	}
	public function set($arr){
		$this->config = array_merge($this->config,$arr);
		$this->config['tid'] = $this->config['tid']?$this->config['tid']:'x';
		$this->config['fid'] = $this->config['fid']?$this->config['fid']:'x';
		$this->config['subject'] = $this->config['subject'] ? $this->config['subject'] : 'reply';
		$this->config['message'] = mb_strlen($this->config['message'])>256?substr($this->config['message'],0,256):$this->config['message'];
	}
	public function GetSitSet($act){
		$charset = strtolower($this->config['charset']);
        $charset = ($charset=="gbk")?"2":((($charset=="utf8"||$charset=="utf-8")?"1":"0"));
		$json = new touclick_json();
		$d = array(
			'Pub'=>$this->config['pubkey'],
			'Pri'=>$this->config['prikey'],
			'CD'=>$charset,
			'ACT'=>$act,
		);
		$data = array(
			'K'=>3,
			'V'=>$json->encode($d),
		);
		$back = $this->tc_request($this->apidourl,$data);
		if(empty($back))
			return false;
		$back = substr($back, 2, -2);
		return $back;
	}
	public function MdlSitSet($op = 'o',$group = array()){
		$charset = strtolower($this->config['charset']);
        $charset = ($charset=="gbk")?"2":((($charset=="utf8"||$charset=="utf-8")?"1":"0"));
		$json = new touclick_json();
		$d = array(
			'Pub'=>$this->config['pubkey'],
			'Pri'=>$this->config['prikey'],
			'CD'=>$charset,
			'Op'=>$op,
			'UGroups'=>$group,
		);
		$data = array(
			'K'=>2,
			'V'=>$json->encode($d),
		);
		$back = $this->tc_request($this->apidourl,$data);
		if(empty($back))
			return false;
		$back = substr($back, 2, -2);
		return $back;
	}
	public function execute(){
		$secreStr = "028 012345678901234567890123456789012345010102030405060708";
        $secreStr .= $this->getLenth($this->config['username']);
        $secreStr .= $this->getLenth("xxx");
        $secreStr .= $this->getLenth($this->config['pubkey']);
        $secreStr .= $this->getLenth($this->config['fid']);
        $secreStr .= $this->getLenth($this->config['tid']);
        $secreStr .= "2   ";
        
        $secreStr .= $this->getLenth($this->config['subject']);
        $secreStr .= $this->getLenth($this->config['message']);
        
        $secreStr .= $this->config['username']."xxx".$this->config['pubkey'].$this->config['fid'].$this->config['tid'].$this->config['mod'].$this->config['subject'].$this->config['message'];
        $charset = strtolower($this->config['charset']);
        $charset = ($charset=="gbk")?"2":((($charset=="utf8"||$charset=="utf-8")?"1":"0"));
		
		$data = array(
            "TKTP" => "02",
            "IPCT" => $this->config['ip'],
            "WK" => $this->config['pubkey'],
            "UK" =>  base64_encode($this->config['username']),
            "DC" => $charset,
			"VS"=> $this->version,
			"UG"=> $this->config['groupid'],
			"FG"=> "1",
            "PTCL" => base64_encode($secreStr),
        );
		$back = $this->tc_request($this->apiurl,$data);
		if(empty($back))
			return false;
		$back = substr($back, 2, -2);
		$json = new touclick_json();
		return $json->decode($back);
	}
	private function getLenth($instr){
        $res = "";
        if(function_exists('mb_strlen')){            
            $len = mb_strlen($instr, $this->config['charset']);
            if($len==0){
                $res = "1   ";
            }elseif($len<=9){
                $res = $len."   ";
            }elseif ($len <=99){
                $res = $len."  ";
            }elseif ($len <=999){
                $res = $len." ";
            }
        }
        return $res;
    }
	private function tc_request($url, $postdata=null) {
		$data = http_build_query ($postdata);
		if(function_exists('curl_exec')){
			$ch = curl_init();
			curl_setopt($ch, CURLOPT_URL, $url);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);
			if(!$postdata){
				curl_setopt($ch, CURLOPT_USERAGENT, $_SERVER['HTTP_USER_AGENT']);
			}else{
				curl_setopt($ch, CURLOPT_POST, 1);
				curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
			}
			@ $data = curl_exec($ch);
			curl_close($ch);
		}else{
			if($postdata)
				$url = $url.'?'.$data;
			$data = file_get_contents($url);
		}
		return $data;
	}
}
?>