<?php

class plugin_chuangmeng_avatar {
	protected $config = array();
	protected $ds = '';

	function plugin_chuangmeng_avatar() {
		global $_G;
		$this->ds = DIRECTORY_SEPARATOR;
		$this->config = $_G['cache']['plugin']['chuangmeng_avatar'];
		$this->config['imagepath'] = str_replace('/',$this->ds,$this->config['imagepath']);
	}
	

	function createavatarimg($uid,$image) {
	
		$uid = abs(intval($uid)); //UID取整数绝对值
		$uid = sprintf("%09d", $uid); //前边加0补齐9位，例如UID为31的用户变成 000000031
		$dir1 = substr($uid, 0, 3);  //取左边3位，即 000
		$dir2 = substr($uid, 3, 2);  //取4-5位，即00
		$dir3 = substr($uid, 5, 2);  //取6-7位，即00
		$avatar_save_path = DISCUZ_ROOT.'uc_server'.$this->ds.'data'.$this->ds.'avatar'.$this->ds.$dir1.$this->ds.$dir2.$this->ds.$dir3;	
		if(!file_exists($avatar_save_path)) {
			mkdir($avatar_save_path,0755,true);
		}
		$avatar_save_name_id = substr($uid, -2);
		
		$pic_info = array();
		$pic_size = getimagesize($image,$pic_info);
		$pic_img = imagecreatefromjpeg($image);		
		
		$bg_color_white = imagecolorallocate($bg_img_big,255, 255, 255);//底色
		
		$avas = array('big'=>145,'middle'=>120,'small'=>48);
		foreach($avas as $n=>$s) {
			$bg_img = imagecreatetruecolor($s,$s);
			imagefill($bg_img,$bg_color_white);
			imagecopyresampled( $bg_img , $pic_img , 0 , 0 , 0 , 0 , $s , $s , $pic_size[0] , $pic_size[1]);
			imagejpeg($bg_img, $avatar_save_path.$this->ds.$avatar_save_name_id.'_avatar_'.$n.'.jpg');
		}
	}
	
	function register_message(){
		global $_G;
		$m=$_G['messageparam'];
		if($m[0]=='register_succeed'){
			$uid=$m[2]['uid'];
			$image_id = intval($_GET['cm_avatar_id']);
			$image = DISCUZ_ROOT.$this->config['imagepath'].$this->ds.$image_id.'.jpg';		
			if($image_id && file_exists($image)) {
				$this->createavatarimg($uid,$image);
			}
		}
		$_G['messageparam']=$m;
	}

}

class plugin_chuangmeng_avatar_member extends plugin_chuangmeng_avatar {
	public function getimage() {
		$path = trim($this->config['imagepath'],'/');
		$files_arr = scandir($path);
		if(is_array($files_arr) && count($files_arr) > 2) {
			$imglist = array();
			foreach($files_arr as $f) {
				if($f != '.' && $f != '..') {
					$imglist[] = '<li>'.$f.'</li>';
				}
			}
			return $imglist;
		}			
	}

	function register_input_output() {
		global $_G;
		$images = $this->getimage();		
		foreach($images as $img) {
			$rand = mt_rand(1,count($images));
			if(!in_array('<img src="'.$this->config[imagepath].'/'.$rand.'.jpg" data-id="'.$rand.'"/>',$list)){
				$list[] = '<img src="'.$this->config[imagepath].'/'.$rand.'.jpg" data-id="'.$rand.'"/>';
			}			
		}
		$lang = $this->config['lang'];
		$list = array_slice($list,0,$this->config['imgnums']);
		$list = implode($list);
		include template('chuangmeng_avatar:register');

		return $return;
	}

}

?>