<?php
if(!defined('IN_DISCUZ')) {
	exit('Access Denied');
}
loadcache('plugin');
$langvar= lang('plugin/batchreply');
$groups=unserialize($_G['cache']['plugin']['batchreply']['groups']);
if(!in_array($_G['groupid'],$groups)){
	showmessage($langvar['noright']);
}
$tid=intval($_GET['tid']);
if($tid){
	$thread=C::t('forum_thread')->fetch($tid);
	if(submitcheck('submit')){
		if($_POST['message']){
			$mes= explode("||",$_POST['message']);
			$content=array();
			foreach($mes as $k=>$message){
				$message=trim($message);
				if($message) $content[]=$message;
			}
			$replynum=count($content);
			if($replynum){
				if(file_exists(DISCUZ_ROOT.'./source/plugin/batchreply/libs/majia.lib.php')){
					@include DISCUZ_ROOT . './source/plugin/batchreply/libs/majia.lib.php';
				}			
				$users=getUsers($_POST['users'],$replynum);
				if($users===false) showmessage($langvar['nomajia']);
			}else{
				showmessage($langvar['nocontent']);
			}
			$fid=$thread['fid'];
			$lastpost=empty($thread['lasetpost'])? $thread['lastpost']:$thread['dateline'];
			$len=intval((time()-$lastpost)/$replynum);
			if($len){
				$times=getTimes($lastpost,$replynum,true,$len);
			}else{
				$times=getTimes($lastpost,$replynum,true,$len);
			}
			foreach($content as $k=>$con){
				$post=array();
				$post['content']=$con;
				$post['fid']=$fid;
				$post['dateline']=$times[$k];
				$post['ip']=$_G['clientip'];
				$post['subject']=$thread['subject'];
				$pid=newpost($post,$tid,$users[$k]);
				if($pid){
					$logdata=array(
						'tid'=>$tid,
						'pid'=>$pid,
						'uid'=>$users[$k]['uid'],
						'username'=>$users[$k]['username'],
						'opuid'=>$_G['uid'],
						'opusername'=>$_G['username'],	
						'dateline'=>time(),	
					);
					C::t('#batchreply#batchreply_log')->insert($logdata);
				}
			}
			showmessage($langvar['ok'],"forum.php?mod=viewthread&tid=$tid", array(), array('locationtime'=>true,'refreshtime'=>3, 'showdialog'=>1, 'showmsg' => true));
		}else{
			showmessage($langvar['nocontent']);
		}
		
	}else{
		include template('batchreply:batchreply');
	}
}else{
	showmessage($langvar['error']);
}

function getTimes($lastpost,$replynum,$status,$len){
	$times=array();
	if($status){
		for($i=1;$i<=$replynum;$i++){
			$newStart=$lastpost+$len;
			$newtime=rand($lastpost,$newStart);
			$times[]=$newtime;
			$lastpost=$newStart;
		}
	}else{
		for($i=1;$i<=$replynum;$i++){
			$newtime=rand($lastpost,time());
		}
	}
	return $times;
}
function newpost($post,$tid,$user){
	global $_G;
	require_once libfile('function/post');
	require_once libfile('function/forum');
	$dateline=$post['dateline'];
	$invisible=0;
	$pid = insertpost(array(
		'fid' => $post['fid'],
		'tid' => $tid,
		'first' => '0',
		'author' => $user['username'],
		'authorid' => $user['uid'],
		'subject' => '',
		'dateline' =>$dateline,
		'message' => htmlspecialchars_decode($post['content'],ENT_QUOTES),
		'useip' => $post['ip'],//,
		'invisible' => $invisible,
		'anonymous' => 0,
		'usesig' => 0,
		'htmlon' => 0,
		'bbcodeoff' => 0,
		'smileyoff' => 0,
		'parseurloff' => 0,
		'attachment' => 0,
		'tags' => '',
		'replycredit' => 0,
		'status' => 0
	 ));
	C::t('common_member_count')->increase(array($user['uid']),array('posts'=>1));
	C::t('forum_thread')->update($tid,array('`replies`=`replies`+1','`lastpost`='.$dateline,'lastposter=\''.$user['username'].'\''),false,false,0,true);
	C::t('forum_forum')->update_forum_counter($post['fid'],0,1,1);
	$subject=htmlspecialchars_decode($post['subject']);
	$lastpost = "$tid\t$subject\t".$dateline."\t".$user['username'];
	C::t('forum_forum')->update(array('fid'=>$post['fid']),array('lastpost'=>$lastpost));
	return $pid; 
}
	

	
function getUsers($users,$replynum){
	global $_G;
	loadcache('plugin');
	$majiaOpen=$_G['cache']['plugin']['batchreply']['majia'];
	$newgroup=$_G['cache']['plugin']['batchreply']['newgroup'];
	$majia=array();
	$users=trim($users);
	if(!$users) $getnum=$replynum;
	else{
		$names= explode(",",$users);
		foreach($names as $k=>$name){
			$name=trim($name);
			$user=C::t('common_member')->fetch_by_username($name);
			if($user){
				$majia[]=array('uid'=>$user['uid'],'username'=>$user['username']);
			}elseif($majiaOpen&&$newgroup&&file_exists(DISCUZ_ROOT.'./source/plugin/batchreply/libs/majia.lib.php')){
				$uid=batchreplyNewUser($name,$newgroup);
				if($uid) $majia[]=array('uid'=>$uid,'username'=>$name);
			}
		}
		$getnum=$replynum-count($majia);
	}
	
	if($getnum>0){
		$uids=$_G['cache']['plugin']['batchreply']['uids'];
		$uids=(array)explode("-",$uids);
		if(count($uids)==2&&intval($uids[0])&&intval($uids[1])){
			$users=C::t('common_member')->range_by_uid(rand(intval($uids[0]),intval($uids[1])-$getnum),$getnum);
			foreach($users as $k=>$user){
				$majia[]=array('uid'=>$user['uid'],'username'=>$user['username']);
			}
		}else{
			return false;
		}
	}
	return $majia;
}


?>